package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.SyncDataConsumer;
import org.msh.etbm.services.mobile.model.ExamMicroscopyData;
import org.msh.etbm.services.mobile.model.FollowupData;
import org.msh.tb.entities.ExamMicroscopy;
import org.msh.tb.entities.LaboratoryExam;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;

import javax.persistence.EntityManager;

/**
 * Created by rmemoria on 5/9/17.
 */
public class ExamMicroscopyDataConsumer extends SyncDataConsumerImpl<ExamMicroscopyData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ExamMicroscopyData data) {
        ExamMicroscopy exam = recoverEntity(ExamMicroscopy.class, data.getServerId());

        moveLaboratoryExamData(data, exam);

        exam.setResult(data.getResult());
        exam.setNumberOfAFB(data.getNumberOfAFB());
        exam.setComments(data.getComments());
        exam.setSampleType(data.getSampleType());
        exam.setDateRelease(data.getDateRelease());
        exam.setSampleNumber(data.getSampleNumber());
        exam.setMethod(getFieldValue(data.getMethod()));
        exam.setLaboratory(getLaboratory(data.getLaboratoryId()));

        getEntityManager().persist(exam);

        return data.getServerId() == null ? exam.getId() : null;
    }


}
